// $Id: CNoteFrequencyPanel.cpp,v 1.4 2007/02/11 02:20:27 paul Exp $

/*
 * All contents of this source code are copyright 2007 Exp Digital Uk.
 * This file forms part of the example projects for the Infinity API.
 * You may not redistribute either the source code or the compiled binary.
 * The Infinity API is covered by a fair use licence which you should have recieved with this
 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
 */

#include "CNoteFrequencyPanel.hpp"
#include "CSCalWindow.hpp"
using Exponent::SCal::CSCalWindow;
using Exponent::SCal::CNoteFrequencyPanel;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CNoteFrequencyPanel, CControlPanel);

//	===========================================================================
CNoteFrequencyPanel::CNoteFrequencyPanel(IControlRoot *root, const long uniqueId, const CRect &area)
                   : CControlPanel(root->getParentWindow(), root, uniqueId, area, NULL)
				   , m_noteFreqComboBox(NULL)
				   , m_noteOutputValueLabel(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CNoteFrequencyPanel);
	
	// Create the midi menu
	CMenu *midiMenu = new CMenu;

	// Load up the miid menu
	CString note;
	CString outputNote;

	// We construct a sub menu item
	long id = -1;
	CSubMenuMenuItem *item = NULL;

	// Loop through all the notes
	for (long i = 0; i < CMidi::CMIDI_MAX_NOTES; i++)
	{
		if (i % 12 == 0)
		{
			CString index;
			index.setStringWithFormat("Octave #%li", id);
			item = new CSubMenuMenuItem(index, ++id);
			midiMenu->addMenuItem(item);
		}

		// Get the note string
		CMidi::getMidiNoteString(i, note);

		// Store the final output
		outputNote = "  ";
		outputNote.appendString(note);
		outputNote.appendString("  ");

		// Add the new menu item
		item->getMutableSubMenu()->addMenuItem(new CMenuItem(note, i));
	}

	this->onDrawDrawThePanelBounds(false);

	// Construct
	m_noteFreqComboBox	   = new CComboBox( this, CControl::CCONTROL_NO_ID_REQUIRED, CSCalWindow::CSCALWINDOW_CONTROL2_RECT, "A4", midiMenu, this);
	m_noteOutputValueLabel = new CTextLabel(this, CControl::CCONTROL_NO_ID_REQUIRED, CSCalWindow::CSCALWINDOW_OUTPUTBOX_RECT, CString::CSTRING_EMPTY_STRING);

	// Reference
	m_noteFreqComboBox->referenced();
	m_noteOutputValueLabel->referenced();

	// Set the format
	m_noteFreqComboBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_noteOutputValueLabel->setTextFormat(CGraphics::e_centerCenterAlign);

	// Colours
	m_noteFreqComboBox->setColours(		CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_noteOutputValueLabel->setColours(	CAlphaColour::CALPHACOLOUR_BLACK, CAlphaColour::CALPHACOLOUR_WHITE, CSCalWindow::CSCALWINDOW_ANSWER_TEXT_COLOUR);
	
	// Create the attributes to pass to the windows
	m_noteFreqComboBox->setMenuWindowAttributes(&CSCalWindow::CSCALWINDOW_MENU_WINDOW_ATTRIBUTES, false);
	m_noteFreqComboBox->setFont(CFont::CFONT_SYSTEM_FONT);

	// Colours of menus. Notice that this *must* be called after the menu window attributes, otherwise there isnt a window to open
	m_noteFreqComboBox->setMenuColours(CSCalWindow::CSCALWINDOW_MENU_COLOURS);

	// Add controls
	this->addControl(m_noteFreqComboBox);
	this->addControl(m_noteOutputValueLabel);

	// Fake output - There is no selected menu item at this stage for us to use in the calculation
	CString output;
	output.setStringWithFormat("%0.02f", CMusicMath::getNoteFrequency(69));
	m_noteOutputValueLabel->setText(output);
	m_noteOutputValueLabel->update();
}

//	===========================================================================
CNoteFrequencyPanel::~CNoteFrequencyPanel()
{
	EXPONENT_CLASS_DESTRUCTION(CNoteFrequencyPanel);
	FORGET_COUNTED_OBJECT(m_noteFreqComboBox);
	FORGET_COUNTED_OBJECT(m_noteOutputValueLabel);
}

//	===========================================================================
void CNoteFrequencyPanel::handleActionEvent(const CActionEvent &event)
{
	this->computeNoteFrequency();
}

//	===========================================================================
void CNoteFrequencyPanel::computeNoteFrequency()
{
	CString output;
	output.setStringWithFormat("%0.02f", CMusicMath::getNoteFrequency(m_noteFreqComboBox->getLastMenuItem()->getId()));
	m_noteOutputValueLabel->setText(output);
	m_noteOutputValueLabel->update();
}